<?php

$body = $_POST['body'];
$title = $_POST['title'];
$imageUrl = $_POST['image'];

require 'get-access-token.php';
$serviceAccountKeyFile = 'service-account-file.json';
$accessToken = getAccessToken($serviceAccountKeyFile);

$url = "https://fcm.googleapis.com/v1/projects/job-circular-93aed/messages:send";

// Prepare FCM message data
$datamsg = array(
    'action' => 'Smart Bkash',
    'title' => $title,
    'body' => $body
);

// Notification message payload with image
$notification = array(
    'title' => $title,
    'body' => $body,
    'image' => $imageUrl
);

$arrayToSend = array(
    'topic' => 'allDevices',
    'data' => $datamsg,
    'notification' => $notification
);

$json = json_encode(['message' => $arrayToSend]);

// Prepare headers
$headers = array();
$headers[] = 'Content-Type: application/json';
$headers[] = 'Authorization: Bearer ' . $accessToken;

// Initialize curl session
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Send the request
$response = curl_exec($ch);

// Check for curl errors
if ($response === FALSE) {
    die('FCM Send Error: ' . curl_error($ch));
}

// Close curl session
curl_close($ch);


?>

